// ImgObj.cpp: CImgObj NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "ImgObj.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CImgObj::CImgObj()
{
	CObjItem::nObjType = IDW_OBJ_IMG;
	m_pPicture = NULL;
}

CImgObj::~CImgObj()
{
	DeletePicture();
}


/******************************************************************************************
 ֐		: void CImgObj::DeletePicture()
 @\		: IPictureC^tF[XJ
 		: Ȃ
 ߂l		: Ȃ
 쐬		: @TH
 쐬		: 2001/11/11
 ******************************************************************************************/
void CImgObj::DeletePicture()
{
	if (m_pPicture)
		m_pPicture->Release();

	m_pPicture = NULL;
}


/******************************************************************************************
 ֐		: int CImgObj::GetHeight(HDC hdc)
 @\		: [hꂽ摜̍擾AHimetricpixelɕϊintԂ
 		: HDC hdc - foCXReLXgnh
 ߂l		: int -------- 摜̍
						   s@@-1
 쐬		: @TH
 쐬		: 2001/11/11
 ******************************************************************************************/
int CImgObj::GetHeight(HDC hdc)
{
	ASSERT(m_pPicture != NULL);

	//*----- ǂݍ񂾉摜̕擾 -----*//
	if (FAILED(m_pPicture->get_Height(&m_lHeight))) {
		TRACE(_T("Failed : IPicture::get_Height\n"));
		return -1;
	}

	//*----- HimetricpixelsɕϊĕԂ -----*//
	return MulDiv(m_lHeight, GetDeviceCaps(hdc, LOGPIXELSY), 2540);
}



/******************************************************************************************
 ֐		: int CImgObj::GetWidht(HDC hdc)
 @\		: [hꂽ摜̕擾AHimetricpixelɕϊintԂ
 		: HDC hdc - foCXReLXgnh
 ߂l		: int -------- 摜̍
						   s@@-1
 쐬		: @TH
 쐬		: 2001/11/11
 ******************************************************************************************/
int CImgObj::GetWidht(HDC hdc)
{
	ASSERT(m_pPicture != NULL);

	//*----- ǂݍ񂾉摜̕擾 -----*//
	if (FAILED(m_pPicture->get_Width(&m_lWidht))) {
		TRACE(_T("Failed : IPicture::get_Width\n"));
		return -1;
	}

	//*----- HimetricpixelsɕϊĕԂ -----*//
	return MulDiv(m_lWidht, GetDeviceCaps(hdc, LOGPIXELSX), 2540);
}


/******************************************************************************************
 ֐		: BOOL CImgObj::Load(LPCTSTR lpszPathName)
 @\		: t@C[hAIPictrueC^[tFCXւ̃|C^Ɋt
 		: t@C
 ߂l		: BOOL
 쐬		: @TH
 쐬		: 2001/11/11
 ******************************************************************************************/
BOOL CImgObj::Load(LPCTSTR lpszPathName)
{
	//*----- t@CJ -----*//
	HANDLE hFile = CreateFile(lpszPathName, GENERIC_READ,
								0, NULL, OPEN_EXISTING, 0, NULL);
//	ASSERT(hFile != NULL);

	if(hFile == INVALID_HANDLE_VALUE)
		return FALSE;

	strIMGPath = lpszPathName;

	//*----- t@CTCY̎擾 -----*//
	DWORD dwFileSize = GetFileSize(hFile, NULL);
//	ASSERT(dwFileSize != -1);

	if(dwFileSize == -1)
		return FALSE;

	//*----- t@CTCỸ̈mۂ -----*//
	HGLOBAL hGlobal = GlobalAlloc(GMEM_MOVEABLE, dwFileSize);
	ASSERT(hGlobal != NULL);

	//*----- mۂ̈bN -----*//
	LPVOID pvData = NULL;
	pvData = GlobalLock(hGlobal);
	ASSERT(pvData != NULL);

	DWORD dwBytesRead = 0;
	//*----- t@C̈ɓǂݍ -----*//
	BOOL bRead = ReadFile(hFile, pvData, dwFileSize, &dwBytesRead, NULL);
	ASSERT(bRead != FALSE);
	GlobalUnlock(hGlobal);
	CloseHandle(hFile);

	LPSTREAM pstm = NULL;
	//*----- IStreamւ̃|C^擾 -----*//
	HRESULT hr = CreateStreamOnHGlobal(hGlobal, TRUE, &pstm);
	ASSERT(SUCCEEDED(hr) && pstm);

	//*----- IPictureւ̃|C^擾 -----*//
	hr = ::OleLoadPicture(pstm, dwFileSize, FALSE,
							IID_IPicture, (LPVOID *)&m_pPicture);
//	ASSERT(SUCCEEDED(hr) && m_pPicture);
	pstm->Release();

	if (FAILED(hr))
		return FALSE;

	return TRUE;
}


/******************************************************************************************
 ֐		: BOOL CImgObj::RenderImage(HDC hdc,long x,long y)
 @\		: 摜foCXReLXgɕ`悷
 		: HDC hdc - foCXReLXgnh
			  long x  - EBhE̍xW
			  long y  - EBhE̍yW
 ߂l		: BOOL
 쐬		: @TH
 쐬		: 2001/11/11
 ******************************************************************************************/
BOOL CImgObj::RenderImage(HDC hdc,long x,long y)
{
	ASSERT(m_pPicture != NULL);

	//*----- C[W̕擾 -----*//
	int cx = GetWidht(hdc);

	//*----- C[W̍擾 -----*//
	int cy = GetHeight(hdc);

	//*----- foCXReLXgImage`悷 -----*//
	HRESULT hr = m_pPicture->Render(hdc, x, y,
									cx, cy,
									0, m_lHeight,
									m_lWidht, -m_lHeight,
									NULL);
	if (FAILED(hr)) {
		TRACE(_T("Failed : IPicture::Render"));
		return FALSE;
	}

	return TRUE;
}

BOOL CImgObj::RenderImage(HDC hdc,long x,long y,long cx,long cy)
{
	ASSERT(m_pPicture != NULL);

	//*----- foCXReLXgImage`悷 -----*//
	HRESULT hr = m_pPicture->Render(hdc, x, y,
									cx, cy,
									0, m_lHeight,
									m_lWidht, -m_lHeight,
									NULL);

	if (FAILED(hr)) {
		TRACE(_T("Failed : IPicture::Render"));
		return FALSE;
	}

	return TRUE;
}


BOOL CImgObj::RenderImage(HDC hdc)
{
	ASSERT(m_pPicture != NULL);

	//o^TCY擾
	int x = rect.left;
	int y = rect.top;
	//*----- C[W̕擾 -----*//
	int cx = GetWidht(hdc);

	//*----- C[W̍擾 -----*//
	int cy = GetHeight(hdc);

	//*----- foCXReLXgImage`悷 -----*//
	HRESULT hr = m_pPicture->Render(hdc, x, y,
									cx, cy,
									0, m_lHeight,
									m_lWidht, -m_lHeight,
									NULL);

	if (FAILED(hr)) {
		TRACE(_T("Failed : IPicture::Render"));
		return FALSE;
	}

	return TRUE;
}


BOOL CImgObj::IsValid()
{
	return (m_pPicture ? TRUE : FALSE);
}
